(function () {
    var app = angular.module('contracts', ['contract']);

    app.directive('contracts', function () {
        return {
            restrict: 'E',
            templateUrl: 'templates/contracts.html',
            controller: function ($rootScope, $scope, $interval) {
                var ctrl = this;
                ctrl.offer = {deadlineHours: 1, pricePerHour: $rootScope.settings.lastPricePerHour};
                ctrl.tab = 'available';
                ctrl.pagination = { page: 1, contractsPerPage: 10 }

                var loadContracts = () => {
                    var showCompleted = ctrl.tab == 'completed';
                    ctrl.contracts = _.orderBy($rootScope.settings.contracts.filter(x => x.completed == showCompleted), "number", "desc");
                    ctrl.pagination.totalPages = Math.ceil(ctrl.contracts.length / ctrl.pagination.contractsPerPage);
                    ctrl.pagination.pages = _.range(1, ctrl.pagination.totalPages);

                    ctrl.contracts = _.take(ctrl.contracts.slice((ctrl.pagination.page-1) * ctrl.pagination.contractsPerPage), ctrl.pagination.contractsPerPage);
                };

                $scope.$watchCollection('settings.inventory', () => loadContracts());
                $scope.$watch('ctrl.pagination.page', () => loadContracts());
                $scope.$on(GameEvents.ContractChange, loadContracts);
                $scope.$watch('ctrl.tab', () => {
                    // Move lost contracts to completed tab
                    GetRootScope().settings.contracts.forEach(x => {
                        if (x.status == ContractStatuses.Lost && !x.completed) {
                            x.completed = true;
                        }
                    });

                    loadContracts();
                });

                ctrl.changePage = pageNumber => {
                    ctrl.pagination.page = pageNumber;
                    $('#candidates').scrollTop(0);
                }
            },
            controllerAs: 'ctrl'
        };
    });
})();
